/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.InferTypeContext;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class SwimmerDogTalent
extends TalentInstance {
    public SwimmerDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        LivingEntity control;
        if (abstractDog.m_9236_().f_46443_) {
            return;
        }
        if (this.level() >= 5 && abstractDog.m_20160_() && (control = abstractDog.m_6688_()) != null && control.m_20069_()) {
            control.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 80, 1, true, false));
        }
    }

    @Override
    public InteractionResult canBeRiddenInWater(AbstractDog dogIn) {
        return this.level() >= 2 ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<Integer> decreaseAirSupply(AbstractDog dogIn, int air) {
        if (this.level() > 0 && dogIn.m_217043_().m_188503_(this.level() + 1) > 0) {
            return InteractionResultHolder.m_19090_((Object)air);
        }
        return InteractionResultHolder.m_19098_((Object)air);
    }

    @Override
    public InteractionResultHolder<Integer> determineNextAir(AbstractDog dogIn, int currentAir) {
        if (this.level() > 0) {
            return InteractionResultHolder.m_19098_((Object)(currentAir + this.level()));
        }
        return InteractionResultHolder.m_19098_((Object)currentAir);
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanSwimUnderwater();
        if (this.level() >= 5) {
            props.setCanBreatheUnderwater();
        }
        if (this.level() > 1) {
            props.addBonusSwimSpeed(Mth.m_14045_((int)this.level(), (int)2, (int)5) * 2);
        }
        if (this.level() >= 2) {
            props.setResistWaterPush();
        }
    }

    @Override
    public InteractionResultHolder<BlockPathTypes> inferType(AbstractDog dog, BlockPathTypes type, InferTypeContext context) {
        if (this.level() < this.getTalent().getMaxLevel() && type == BlockPathTypes.WATER && this.checkOverrideWalkableForWater(context)) {
            return InteractionResultHolder.m_19090_((Object)BlockPathTypes.WALKABLE);
        }
        return super.inferType(dog, type, context);
    }

    public boolean checkOverrideWalkableForWater(InferTypeContext context) {
        if (!context.teleport()) {
            return true;
        }
        LivingEntity owner = context.owner().orElse(null);
        if (owner == null) {
            return false;
        }
        return owner.m_20069_();
    }
}

